(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15624,        307]*)
(*NotebookOutlinePosition[     16276,        330]*)
(*  CellTagsIndexPosition[     16232,        326]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(f[x_] = 1 + \(\@3\) x\)], "Input"],

Cell[BoxData[
    \(1 + \@3\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[x_] = 1 - \(\@3\) x\)], "Input"],

Cell[BoxData[
    \(1 - \@3\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {Line[{{Cos[Pi/2], Sin[Pi/2]}, {Cos[Pi/2 + \ \ 2\ Pi/3], 
              Sin[Pi/2 + \ \ 2\ Pi/3]}, {Cos[Pi/2 + \ \ 4\ Pi/3], 
              Sin[Pi/2 + \ \ 4\ Pi/3]}, {Cos[Pi/2], Sin[Pi/2]}}], 
        Line[{{\(-0.5\), \(-1\)/2}, {\(-0.5\), f[\(-0.5\)]}, {0.5, 
              g[0.5]}, {0.5, \(-1\)/2}}]}\)], "Input"],

Cell[BoxData[
    \({Line[{{0, 
            1}, {\(-\(\@3\/2\)\), \(-\(1\/2\)\)}, {\@3\/2, \(-\(1\/2\)\)}, \
{0, 1}}], 
      Line[{{\(-0.5`\), \(-\(1\/2\)\)}, {\(-0.5`\), 
            0.1339745962155614`}, {0.5`, 
            0.1339745962155614`}, {0.5`, \(-\(1\/2\)\)}}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{Thickness[ .003], A}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.549857 0.210916 0.392403 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.003 w
[ ] 0 setdash
.5 .60332 m
.02381 .01472 L
.97619 .01472 L
.5 .60332 L
s
.22507 .01472 m
.22507 .26349 L
.77493 .26349 L
.77493 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool000Oooooo00004P0000Soool000Soool00`000?oo
ooooo`0eoooo00<0003oooooool0Voooo`030000oooooooo03Goool00`000?ooooooo`07oooo0009
oooo00<0003oooooool0=?ooo`030000oooooooo09_oool00`000?ooooooo`0doooo00<0003ooooo
ool02?ooo`002Oooo`030000oooooooo03Coool00`000?ooooooo`2Koooo00<0003oooooool0=?oo
o`030000oooooooo00Soool000[oool00`000?ooooooo`0coooo00<0003oooooool0Voooo`030000
oooooooo03?oool00`000?ooooooo`09oooo000;oooo00<0003oooooool0<_ooo`030000oooooooo
09_oool00`000?ooooooo`0boooo00<0003oooooool02_ooo`003?ooo`030000oooooooo037oool0
0`000?ooooooo`2Koooo00<0003oooooool0<Oooo`030000oooooooo00_oool000goool00`000?oo
ooooo`0`oooo00<0003oooooool0Voooo`030000oooooooo033oool00`000?ooooooo`0<oooo000=
oooo00<0003oooooool0<?ooo`030000oooooooo09_oool00`000?ooooooo`0`oooo00<0003ooooo
ool03?ooo`003_ooo`030000oooooooo02ooool00`000?ooooooo`2Koooo00<0003oooooool0;ooo
o`030000oooooooo00goool000ooool00`000?ooooooo`0^oooo00<0003oooooool0Voooo`030000
oooooooo02koool00`000?ooooooo`0>oooo000@oooo00<0003oooooool0;Oooo`030000oooooooo
09_oool00`000?ooooooo`0]oooo00<0003oooooool03oooo`004Oooo`030000oooooooo02coool0
0`000?ooooooo`2Koooo00<0003oooooool0;?ooo`030000oooooooo013oool001;oool00`000?oo
ooooo`0[oooo00<0003oooooool0Voooo`030000oooooooo02_oool00`000?ooooooo`0Aoooo000B
oooo00<0003oooooool0:oooo`030000oooooooo09_oool00`000?ooooooo`0[oooo00<0003ooooo
ool04Oooo`004oooo`030000oooooooo02[oool00`000?ooooooo`2Koooo00<0003oooooool0:_oo
o`030000oooooooo01;oool001Coool00`000?ooooooo`0Yoooo00<0003oooooool0Voooo`030000
oooooooo02Woool00`000?ooooooo`0Coooo000Eoooo00<0003oooooool0:?ooo`030000oooooooo
09_oool00`000?ooooooo`0Xoooo00<0003oooooool05?ooo`005_ooo`030000oooooooo02Ooool0
0`000?ooooooo`2Koooo00<0003oooooool09oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Woooo00<0003oooooool0Voooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool09_ooo`030000oooooooo09_oool00`000?ooooooo`0Voooo00<0003ooooo
ool05_ooo`006?ooo`030000oooooooo02Goool00`000?ooooooo`2Koooo00<0003oooooool09Ooo
o`030000oooooooo01Ooool001Woool00`000?ooooooo`0Toooo00<0003oooooool0Voooo`030000
oooooooo02Coool00`000?ooooooo`0Hoooo000Joooo00<0003oooooool08oooo`030000oooooooo
09_oool00`000?ooooooo`0Soooo00<0003oooooool06Oooo`006_ooo`030000oooooooo02?oool0
0`000?ooooooo`2Koooo00<0003oooooool08oooo`030000oooooooo01Woool001_oool00`000?oo
ooooo`0Roooo00<0003oooooool0Voooo`030000oooooooo02;oool00`000?ooooooo`0Joooo000L
oooo00<0003oooooool08Oooo`030000oooooooo09_oool00`000?ooooooo`0Qoooo00<0003ooooo
ool06oooo`007Oooo`030000oooooooo023oool00`000?ooooooo`2Koooo00<0003oooooool08?oo
o`030000oooooooo01coool001koool00`000?ooooooo`0Ooooo00<0003oooooool0Voooo`030000
oooooooo01ooool00`000?ooooooo`0Moooo000Noooo00<0003oooooool07oooo`030000oooooooo
09_oool00`000?ooooooo`0Ooooo00<0003oooooool07Oooo`007oooo`030000oooooooo01koool0
0`000?ooooooo`2Koooo00<0003oooooool07_ooo`030000oooooooo01koool0023oool00`000?oo
ooooo`0Moooo00<0003oooooool0Voooo`030000oooooooo01goool00`000?ooooooo`0Ooooo000Q
oooo00<0003oooooool07?ooo`030000oooooooo09_oool00`000?ooooooo`0Loooo00<0003ooooo
ool08?ooo`008_ooo`030000oooooooo01_oool00`000?ooooooo`2Koooo00<0003oooooool06ooo
o`030000oooooooo027oool002?oool00`000?ooooooo`0Joooo00<0003oooooool0Voooo`030000
oooooooo01[oool00`000?ooooooo`0Roooo000Soooo00<0003oooooool06_ooo`030000oooooooo
09_oool00`000?ooooooo`0Joooo00<0003oooooool08_ooo`009?ooo`030000oooooooo01Woool0
0`000?ooooooo`2Koooo00<0003oooooool06Oooo`030000oooooooo02?oool002Goool00`000?oo
ooooo`0Hoooo00<0003oooooool0Voooo`030000oooooooo01Soool00`000?ooooooo`0Toooo000V
oooo00<0003oooooool05oooo`030000oooooooo09_oool00`000?ooooooo`0Goooo00<0003ooooo
ool09Oooo`009oooo`030000oooooooo01Koool00`000?ooooooo`2Koooo00<0003oooooool05_oo
o`030000oooooooo02Koool002Ooool00`000?ooooooo`0Foooo00<0003oooooool0Voooo`030000
oooooooo01Koool00`000?ooooooo`0Voooo000Xoooo00<0003oooooool05Oooo`030000oooooooo
09_oool00`000?ooooooo`0Eoooo00<0003oooooool09oooo`00:Oooo`030000oooooooo01Coool0
0`000?ooooooo`2Koooo00<0003oooooool05?ooo`030000oooooooo02Soool002[oool00`000?oo
ooooo`0Coooo00<0003oooooool0Voooo`030000oooooooo01?oool00`000?ooooooo`0Yoooo000[
oooo00<0003oooooool04_ooo`030000oooooooo09_oool00`000?ooooooo`0Boooo00<0003ooooo
ool0:_ooo`00:oooo`030000oooooooo01;oool00`000?ooooooo`2Koooo00<0003oooooool04_oo
o`030000oooooooo02[oool002coool00`000?ooooooo`0Aoooo00<0003oooooool0Voooo`030000
oooooooo017oool00`000?ooooooo`0[oooo000]oooo00<0003oooooool04?ooo`030000oooooooo
09_oool00`000?ooooooo`0@oooo00<0003oooooool0;?ooo`00;_ooo`030000oooooooo00ooool0
0`000?ooooooo`2Koooo00<0003oooooool03oooo`030000oooooooo02goool002ooool00`000?oo
ooooo`0>oooo00<0003oooooool0Voooo`030000oooooooo00koool00`000?ooooooo`0^oooo000_
oooo00<0003oooooool03_ooo`030000oooooooo09_oool00`000?ooooooo`0>oooo00<0003ooooo
ool0;_ooo`00<?ooo`030000oooooooo00goool00`000?ooooooo`2Koooo00<0003oooooool03Ooo
o`030000oooooooo02ooool0037oool00`000?ooooooo`0<oooo00<0003oooooool0Voooo`030000
oooooooo00coool00`000?ooooooo`0`oooo000boooo00<0003oooooool02oooo`030000oooooooo
09_oool00`000?ooooooo`0;oooo00<0003oooooool0<Oooo`00<oooo`030000oooooooo00[oool0
0`000?ooooooo`2Koooo00<0003oooooool02_ooo`030000oooooooo03;oool003Coool00`000?oo
ooooo`09oooo00<0003oooooool0Voooo`030000oooooooo00Woool00`000?ooooooo`0coooo000d
oooo00<0003oooooool02Oooo`030000oooooooo09_oool00`000?ooooooo`09oooo00<0003ooooo
ool0<oooo`00=Oooo`030000oooooooo00Soool00`000?ooooooo`2Koooo00<0003oooooool02?oo
o`030000oooooooo03Coool003Koool00`000?ooooooo`07oooo00<0003oooooool0Voooo`030000
oooooooo00Ooool00`000?ooooooo`0eoooo000goooo00<0003oooooool01_ooo`030000oooooooo
09_oool00`000?ooooooo`06oooo00<0003oooooool0=_ooo`00>?ooo`030000oooooooo00Goool0
0`000?ooooooo`2Koooo00<0003oooooool01Oooo`030000oooooooo03Ooool003Soool00`000?oo
ooooo`05oooo00<0003oooooool0Voooo`030000oooooooo00Goool00`000?ooooooo`0goooo000i
oooo00<0003oooooool01?ooo`030000oooooooo09_oool00`000?ooooooo`04oooo00<0003ooooo
ool0>?ooo`00>_ooo`030000oooooooo00?oool00`000?ooooooo`2Koooo00<0003oooooool00ooo
o`030000oooooooo03Woool003_oool00`000?ooooooo`02oooo00<0003oooooool0Voooo`030000
oooooooo00;oool00`000?ooooooo`0joooo000loooo00D0003oooooooooool00000WOooo`050000
oooooooooooo000003goool003coool01@000?ooooooooooo`00002Moooo00D0003oooooooooool0
0000?Oooo`00?Oooo`040000oooooooo0000WOooo`040000oooooooo0000?_ooo`00?_ooo`030000
oooo000009goool00`000?ooo`00000ooooo000ooooo0P0009goool20000@?ooo`00@?ooo`030000
oooooooo09_oool00`000?ooooooo`0ooooo0010ooooW`00047oool0047oool00`000?ooooooo`2I
oooo00<0003oooooool0@?ooo`00@_ooo`030000oooooooo09Ooool00`000?ooooooo`11oooo0013
oooo00<0003oooooool0UOooo`030000oooooooo04;oool004Coool00`000?ooooooo`2Coooo00<0
003oooooool0@oooo`00AOooo`030000oooooooo097oool00`000?ooooooo`14oooo0015oooo00<0
003oooooool0TOooo`030000oooooooo04Coool004Koool00`000?ooooooo`2?oooo00<0003ooooo
ool0AOooo`00Aoooo`030000oooooooo08goool00`000?ooooooo`16oooo0018oooo00<0003ooooo
ool0Roooo`030000oooooooo04Ooool004Woool00`000?ooooooo`29oooo00<0003oooooool0B?oo
o`00BOooo`030000oooooooo08Woool00`000?ooooooo`18oooo001:oooo00<0003oooooool0Qooo
o`030000oooooooo04Woool004_oool00`000?ooooooo`25oooo00<0003oooooool0B_ooo`00C?oo
o`030000oooooooo08?oool00`000?ooooooo`1;oooo001=oooo00<0003oooooool0POooo`030000
oooooooo04coool004goool00`000?ooooooo`21oooo00<0003oooooool0C?ooo`00C_ooo`030000
oooooooo07ooool00`000?ooooooo`1=oooo001?oooo00<0003oooooool0OOooo`030000oooooooo
04koool0053oool00`000?ooooooo`1koooo00<0003oooooool0Coooo`00DOooo`030000oooooooo
07Woool00`000?ooooooo`1@oooo001Aoooo00<0003oooooool0NOooo`030000oooooooo053oool0
05;oool00`000?ooooooo`1goooo00<0003oooooool0DOooo`00Doooo`030000oooooooo07Goool0
0`000?ooooooo`1Boooo001Doooo00<0003oooooool0Loooo`030000oooooooo05?oool005Goool0
0`000?ooooooo`1aoooo00<0003oooooool0E?ooo`00E_ooo`030000oooooooo06ooool00`000?oo
ooooo`1Eoooo001Foooo00<0003oooooool0Koooo`030000oooooooo05Goool005Ooool00`000?oo
ooooo`1]oooo00<0003oooooool0E_ooo`00F?ooo`030000oooooooo06_oool00`000?ooooooo`1G
oooo001Ioooo00<0003oooooool0JOooo`030000oooooooo05Soool005[oool00`000?ooooooo`1W
oooo00<0003oooooool0FOooo`00F_ooo`030000oooooooo06Ooool00`000?ooooooo`1Ioooo001K
oooo00<0003oooooool0IOooo`030000oooooooo05[oool005coool00`000?ooooooo`1Soooo00<0
003oooooool0Foooo`00GOooo`030000oooooooo067oool00`000?ooooooo`1Loooo001Noooo00<0
003oooooool0Goooo`030000oooooooo05goool005koool00`000?ooooooo`1Ooooo00<0003ooooo
ool0GOooo`00Goooo`030000oooooooo05goool00`000?ooooooo`1Noooo001Poooo00<0003ooooo
ool0Foooo`030000oooooooo05ooool0067oool00`000?ooooooo`1Ioooo00<0003oooooool0H?oo
o`00H_ooo`030000oooooooo05Ooool00`000?ooooooo`1Qoooo001Roooo00<0003oooooool0Eooo
o`030000oooooooo067oool006?oool00`000?ooooooo`1Eoooo00<0003oooooool0H_ooo`00I?oo
o`030000oooooooo05?oool00`000?ooooooo`1Soooo001Uoooo00<0003oooooool0DOooo`030000
oooooooo06Coool006Koool00`000?ooooooo`1?oooo00<0003oooooool0IOooo`00Ioooo`030000
oooooooo04goool00`000?ooooooo`1Voooo001Woooo00<0003oooooool0COooo`030000oooooooo
06Koool006Soool00`000?ooooooo`1;oooo00<0003oooooool0Ioooo`00JOooo`030000oooooooo
04Woool00`000?ooooooo`1Xoooo001Zoooo00<0003oooooool0Aoooo`030000oooooooo06Woool0
06_oool00`000?ooooooo`15oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo04Goool0
0`000?ooooooo`1Zoooo001/oooo00<0003oooooool0@oooo`030000oooooooo06_oool006goool0
0`000?ooooooo`11oooo00<0003oooooool0K?ooo`00K_ooo`030000oooooooo03ooool00`000?oo
ooooo`1]oooo001_oooo00<0003oooooool0?Oooo`030000oooooooo06koool006ooool00`000?oo
ooooo`0moooo00<0003oooooool0K_ooo`00L?ooo`030000oooooooo03_oool00`000?ooooooo`1_
oooo001aoooo00<0003oooooool0>Oooo`030000oooooooo073oool007;oool00`000?ooooooo`0g
oooo00<0003oooooool0LOooo`00Loooo`030000oooooooo03Goool00`000?ooooooo`1boooo001c
oooo00<0003oooooool0=Oooo`030000oooooooo07;oool007Coool00`000?ooooooo`0coooo00<0
003oooooool0Loooo`00MOooo`030000oooooooo037oool00`000?ooooooo`1doooo001foooo00<0
003oooooool0;oooo`030000oooooooo07Goool007Ooool00`000?ooooooo`0]oooo00<0003ooooo
ool0M_ooo`00N?ooo`030000oooooooo02_oool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool0:oooo`030000oooooooo07Ooool007Woool00`000?ooooooo`0Yoooo00<0003oooooool0N?oo
o`00N_ooo`030000oooooooo02Ooool00`000?ooooooo`1ioooo001koooo00<0003oooooool09Ooo
o`030000oooooooo07[oool007coool00`000?ooooooo`0Soooo00<0003oooooool0Noooo`00O?oo
o`030000oooooooo02?oool00`000?ooooooo`1koooo001moooo00<0003oooooool08Oooo`030000
oooooooo07coool007koool00`000?ooooooo`0Ooooo00<0003oooooool0OOooo`00Ooooo`030000
oooooooo01goool00`000?ooooooo`1noooo0020oooo00<0003oooooool06oooo`030000oooooooo
07ooool0083oool00`000?ooooooo`0Koooo00<0003oooooool0Ooooo`00POooo`030000oooooooo
01Woool00`000?ooooooo`20oooo0022oooo00<0003oooooool05oooo`030000oooooooo087oool0
08?oool00`000?ooooooo`0Eoooo00<0003oooooool0P_ooo`00Q?ooo`030000oooooooo01?oool0
0`000?ooooooo`23oooo0024oooo00<0003oooooool04oooo`030000oooooooo08?oool008Goool0
0`000?ooooooo`0Aoooo00<0003oooooool0Q?ooo`00Q_ooo`030000oooooooo00ooool00`000?oo
ooooo`25oooo0027oooo00<0003oooooool03Oooo`030000oooooooo08Koool008Soool00`000?oo
ooooo`0;oooo00<0003oooooool0Qoooo`00ROooo`030000oooooooo00Woool00`000?ooooooo`28
oooo0029oooo00<0003oooooool02Oooo`030000oooooooo08Soool008[oool00`000?ooooooo`07
oooo00<0003oooooool0ROooo`00Roooo`030000oooooooo00Goool00`000?ooooooo`2:oooo002<
oooo00<0003oooooool00oooo`030000oooooooo08_oool008goool01@000?ooooooooooo`00002>
oooo002=oooo00D0003oooooooooool00000S_ooo`00S_ooo`030000oooo000008ooool008ooool0
0`000?ooooooo`2>oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.911583, -0.537506, \
0.00635249, 0.00890147}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<HW5.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 54, 1, 32, "Input"],
Cell[1796, 54, 44, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1877, 60, 54, 1, 32, "Input"],
Cell[1934, 63, 44, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2015, 69, 338, 5, 150, "Input"],
Cell[2356, 76, 287, 6, 81, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2680, 87, 70, 1, 30, "Input"],
Cell[2753, 90, 12483, 198, 186, 740, 49, "GraphicsData", "PostScript", \
"Graphics"],
Cell[15239, 290, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15406, 298, 69, 1, 30, "Input"],
Cell[15478, 301, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

